#!/usr/bin/env python
#
# Copyright 2009 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 51 Franklin Street,
# Boston, MA 02110-1301, USA.
# 
from gnuradio import gr

from gnuradio import gr, gru
from gnuradio.eng_option import eng_option
from gnuradio import eng_notation
#from gnuradio import optfir
from optparse import OptionParser
import time
import os.path
import sys

class my_graph(gr.top_block):

    def __init__(self):
        gr.top_block.__init__(self)

        parser = OptionParser (option_class=eng_option)
        parser.add_option("-d", "--decim", type="int", default=None,
                          help="set usrp decimation which was used to capture the samples [default=%default]")
        parser.add_option("-R", "--sample-rate", type="eng_float", default=None,
                          help="set samplerate of the capture file [default=%default]")
        parser.add_option("-f", "--freq", type="eng_float", default=0.0e6,
                          help="set RF center frequency of the capture file [default=%default])", metavar="FREQ")
        parser.add_option("-b", "--bandwidth", type="eng_float", default=200.0e3,
                          help="set bandwith of the filters [default=%default])")
        parser.add_option("-t", "--trans_width", type="eng_float", default=20.0e3,
                          help="set transition-width of the filters [default=%default])")
#        parser.add_option("-g", "--gain", type="eng_float", default=0.0,
#                          help="set gain in dB [default=%default]")
#        parser.add_option("-s", "--seconds", type="eng_float", default=None,
#                          help="Number of seconds to process")
        parser.add_option("-i", "--infile", type="string", default=None,
                          help="set input filename")
        parser.add_option("-o", "--outfile", type="string", default=None,
                          help="set output filename")
        parser.add_option( "-s","--input-shorts", action="store_true", default=False,
                          help="input interleaved shorts in stead of complex floats")
        parser.add_option( "-S","--output-shorts", action="store_true", default=False,
                          help="output interleaved shorts in stead of complex floats")
        (options, args) = parser.parse_args()

        num_freqs=len(args)
        if 0==num_freqs:
            sys.stderr.write("You should provide one or more frequencies for the filter at the end of the commandline options.")
            parser.print_help()
            raise SystemExit

        if options.decim is None:
           if options.sample_rate is None:
             sys.stderr.write("You have to set either sample_rate or decim.")
             parser.print_help()
             raise SystemExit
           else: 
             sample_rate=options.sample_rate
        else:
           if not (options.sample_rate is None):
             sys.stderr.write("Setting sample-rate and decim is mutually exclusive.")
             raise SystemExit
           else:
             options.sample_rate=64.0e6/options.decim
          
        rf_centerfreq=options.freq
        freqs=[]
        for freq in args:
          try:
            f=float(freq)
          except ValueError:
            sys.stderr.write("Error: Cannot parse frequency ",freq, " as a float" )
            raise SystemExit
          print "add freq: ",f
          freqs.append(f)

        if options.outfile is None:
            parser.print_help()
            sys.stderr.write("You must provide an output filename with -o OUTPUT\n")
            raise SystemExit
        print "outputting file: ",options.outfile

        if options.infile is None:
            parser.print_help()
            sys.stderr.write("You must provide an input filename with -i INPUT\n")
            raise SystemExit
        print "input from file: ",options.infile

        combined_taps=None
        for freq in freqs:
          freq=freq-rf_centerfreq
          print freq-0.5*options.bandwidth,freq+0.5*options.bandwidth
          new_taps =gr.firdes.complex_band_pass (
                1.0,
		options.sample_rate,
		freq-0.5*options.bandwidth,
		freq+0.5*options.bandwidth,
		options.trans_width,
		gr.firdes.WIN_HAMMING ) 	
          if combined_taps is None:
            combined_taps=[]
            for i in range(len(new_taps)):
              combined_taps.append(new_taps[i])
            print "initial taps: len=",len(combined_taps)#," taps=",combined_taps
          else:
            for i in range(len(combined_taps)):
             combined_taps[i]=combined_taps[i]+new_taps[i]
        print "final taps: len=",len(combined_taps)#," taps=",combined_taps

        multi_filter=gr.fir_filter_ccc(1,combined_taps) 
        if options.input_shorts:
          sizeof_input_samples=gr.sizeof_short
          is2c=gr.interleaved_short_to_complex()
        else:
          sizeof_input_samples=gr.sizeof_gr_complex
        if options.output_shorts:
          sizeof_output_samples=gr.sizeof_short
          c2is=gr.complex_to_interleaved_short()
        else:
          sizeof_output_samples=gr.sizeof_gr_complex
        src  = gr.file_source(sizeof_input_samples,options.infile,False)
        sink = gr.file_sink(sizeof_output_samples,options.outfile)

        if options.input_shorts:
          self.connect(src,is2c,multi_filter)
        else:
          self.connect(src,multi_filter)

        if options.output_shorts:
          self.connect(multi_filter,c2is,sink)
        else:
          self.connect(multi_filter,sink)	      

def main ():
    my_graph().run()

if __name__ == '__main__':
    main ()
