#!/usr/bin/env octave

xambi_filename = argv(){1};
pfs_filename = argv(){2};
#note ppm_filename must have a image extension that pfsout understands
# It is best to use a HDR image format (uses floating point for storing pixels)
# .pfs and .exr are the most common hdr file formats
#
# You can also use one of the non-hdr image formats pfs supports
# pfsin --help
#Recognized file formats and extensions:
# Radiance RGBE - .pic, .hdr
# TIFF (incl. LogLuv) - .tiff, .tif
# PNM, PPM - .ppm, .pnm
# JPEG - .jpeg, .jpg
# PNG - .png
# PFS - .pfs
# OpenEXR - .exr
# PFM - .pfm
# DPX - .dpx
# GIF - .gif
# BMP - .bmp
# EPS - .eps
# Canon 350D RAW - .cr2
# (and other camera RAW formats recognized by dcraw)
a = read_xambi(xambi_filename);
a_finite=filter_nonfinite(a);

plot_xambi_to_file_pfs(a_finite, pfs_filename);

